﻿/* Skript zur Demonstration von MERGE-Anweisungen
 * Als Benutzer SCOTT ausführen
 */
 

-- View zur Simulation einer SLAVE-Tabelle, die auf den MASTER gemerget werden soll
create or replace view emp_dept_20 as
select empno, ename, mgr, job, 
       case ename 
       when 'JONES' then sal + 20
       when 'FORD' then sal - 50
       else sal end sal
  from emp
 where deptno = 20
union all
select 8000, 'MEIER', 7839, 'ANALYST', 2800
  from dual;
  
-- Einfache MERGE-Anweisung
-- Daten vor dem Merge
select ename, job, sal
  from emp
 where deptno = 20;
 
-- MERGE
merge into emp e
using emp_dept_20 v
   on (e.empno = v.empno)
 when matched then update set
      e.sal = v.sal
 when not matched then insert 
      (empno, ename, mgr, job, sal, deptno)
      values
      (v.empno, v.ename, v.mgr, v.job, v.sal, 20);
      
-- Daten nach dem Merge
select ename, job, sal
  from emp
 where deptno = 20;
 
rollback;

-- MERGE-ANweisung als UPDATE-Ersatz
-- Die Anweisung setzt Tabelle PROD_TABLE voraus,
-- die in der Skript-Datei update-Anweisungen.sql im gleichen Verzeichnis angelegt wurde.
-- als Benutzer SH ausführen
explain plan for
merge into prod_table p
using (select prod_id, row_number() over (order by prod_id) rn
         from prod_table) v
   on (p.prod_id = v.prod_id)
 when matched then update set
      prod_total_id = v.rn;

-- MERGE-Anweisung mit DELETE-Zweig
-- Als Bnutzer SCOTT ausführen
-- Daten vor dem Merge
select ename, job, sal
  from emp
 where deptno = 20;
 
-- MERGE
merge into emp e
using emp_dept_20 v
   on (e.empno = v.empno)
 when matched then update set
      e.sal = v.sal
      delete where ename = 'ADAMS'
 when not matched then insert 
      (empno, ename, mgr, job, sal, deptno)
      values
      (v.empno, v.ename, v.mgr, v.job, v.sal, 20);
      
-- Daten nach dem Merge
select ename, job, sal
  from emp
 where deptno = 20;
 
rollback;


-- MERGE-Anweisung mit konditionalem Update
-- Daten vor dem Merge
select ename, job, sal
  from emp
 where deptno = 20;
 
-- MERGE
merge into emp e
using emp_dept_20 v
   on (e.empno = v.empno)
 when matched then update set
      e.sal = v.sal
      where e.sal = 3000
 when not matched then insert 
      (empno, ename, mgr, job, sal, deptno)
      values
      (v.empno, v.ename, v.mgr, v.job, v.sal, 20);
 
-- MERGE
merge into emp e
using emp_dept_20 v
   on (e.empno = v.empno)
 when matched then update set
      e.sal = v.sal
      where e.sal = 3000
 when not matched then insert 
      (empno, ename, mgr, job, sal, deptno)
      values     (v.empno, v.ename, v.mgr, v.job, v.sal, 20);
      
-- Daten nach dem Merge
select ename, job, sal
  from emp
 where deptno = 20;
 
rollback;